/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.service;

import filenet.vw.api.VWDBExecuteConnection;
import filenet.vw.toolkit.admin.resources.VWResource;

public class VWDBExecuteInfo {
    public static final int STATUS_NONE = 0;
    public static final int STATUS_NEW = 1;
    public static final int STATUS_MODIFIED = 2;
    public static final int SEL_DB_PARAM = 0;
    public static final int SEL_JDBC = 1;
    protected VWDBExecuteConnection m_dbExDef = null;
    protected int m_nStatus = 0;
    protected int m_selOption = 0;
    protected boolean m_reenterPWD = false;

    VWDBExecuteInfo(VWDBExecuteConnection dbExDef) {
        this.m_dbExDef = dbExDef;
        if (dbExDef != null) {
            String dbName = this.m_dbExDef.getDbName();
            String url = this.m_dbExDef.getURL();
            this.m_selOption = (dbName == null || dbName.length() <= 0) && url != null && url.length() > 0 ? 1 : 0;
        }
    }

    protected String getName() {
        if (this.m_dbExDef != null) {
            return this.m_dbExDef.getName();
        }
        return null;
    }

    protected void setName(String name) {
        this.m_dbExDef.setName(name);
        this.m_nStatus |= 2;
        this.m_dbExDef.setHasChanged(true);
        this.resubmitPWD();
    }

    protected int getDBType() {
        return this.m_dbExDef.getDbType();
    }

    protected String getDataBaseType() {
        String sDbType = null;
        switch (this.m_dbExDef.getDbType()) {
            case 1: {
                sDbType = VWResource.MSSQL;
                break;
            }
            case 2: {
                sDbType = VWResource.Oracle;
                break;
            }
            case 3: {
                sDbType = VWResource.DB2;
                break;
            }
            default: {
                sDbType = VWResource.MSSQL;
            }
        }
        return sDbType;
    }

    protected void setDBType(int type) {
        this.m_dbExDef.setDbType(type);
        this.m_nStatus |= 2;
        this.m_dbExDef.setHasChanged(true);
        this.resubmitPWD();
    }

    protected String getDBName() {
        return this.m_dbExDef.getDbName();
    }

    protected void setDBName(String dbName) {
        this.m_dbExDef.setDbName(dbName);
        this.m_nStatus |= 2;
        this.m_dbExDef.setHasChanged(true);
        this.resubmitPWD();
    }

    protected String getDBHost() {
        return this.m_dbExDef.getDbHostName();
    }

    protected void setDBHost(String dbHost) {
        this.m_dbExDef.setDbHostName(dbHost);
        this.m_nStatus |= 2;
        this.m_dbExDef.setHasChanged(true);
        this.resubmitPWD();
    }

    protected String getDBPort() {
        int port = this.m_dbExDef.getDbPort();
        if (port <= 0) {
            return "";
        }
        return Integer.toString(port);
    }

    protected void setDBPort(String dbPort) {
        int port = 0;
        if (dbPort != null && dbPort.length() > 0) {
            port = Integer.parseInt(dbPort);
        }
        this.m_dbExDef.setDbPort(port);
        this.m_nStatus |= 2;
        this.m_dbExDef.setHasChanged(true);
        this.resubmitPWD();
    }

    protected String getDBUser() {
        return this.m_dbExDef.getDbUserId();
    }

    protected void setDBUser(String id) {
        this.m_dbExDef.setDbUserId(id);
        this.m_nStatus |= 2;
        this.m_dbExDef.setHasChanged(true);
        this.resubmitPWD();
    }

    protected String getDBPWD() {
        return this.m_dbExDef.getPWD();
    }

    protected void setDBPWD(String pwd) {
        this.m_dbExDef.setPWD(pwd);
        this.m_nStatus |= 2;
        this.m_dbExDef.setHasChanged(true);
        this.m_reenterPWD = false;
    }

    protected String getURL() {
        return this.m_dbExDef.getURL();
    }

    protected void setURL(String url) {
        this.m_dbExDef.setURL(url);
        this.m_nStatus |= 2;
        this.m_dbExDef.setHasChanged(true);
        this.resubmitPWD();
    }

    protected void setHasChanged(boolean b) {
        this.m_dbExDef.setHasChanged(b);
    }

    public boolean isNew() {
        return (this.m_nStatus & 1) == 1;
    }

    public boolean isModified() {
        return (this.m_nStatus & 2) == 2;
    }

    public void copy(VWDBExecuteInfo o) {
        this.m_dbExDef.copy(o.m_dbExDef);
        this.m_nStatus = o.m_nStatus;
        this.resubmitPWD();
    }

    public void update() {
        if (this.isModified() || this.isNew()) {
            this.setHasChanged(true);
            if (this.m_selOption == 1) {
                this.m_dbExDef.setDbName(null);
                this.m_dbExDef.setDbPort(0);
                this.m_dbExDef.setDbHostName(null);
            }
        }
    }

    public boolean needReEnterPWD() {
        return this.m_reenterPWD;
    }

    protected void resubmitPWD() {
        if (!this.isNew()) {
            this.m_dbExDef.setPWD("");
            this.m_reenterPWD = true;
        }
    }
}

